import {world, World, Entity} from "@minecraft/server";

export class Database_Static{
    /**
     * Sets a new table
     * @param {string} name The new table's key
     * @returns {Map}
     */
    static newTable(name){
        if(name == ""){
            world.sendMessage("New Table name cannot be \"\"! Return undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                world.sendMessage("New Table's name already used! Returns undefined"); return undefined;
            }else {
                this.table.set(name, new Map());
                world.sendMessage("New Table succesfully set! Returns "+name); return this.table.get(name);
            };
        };
    };
    /**
     * Gets a Table
     * @param {string} name The table's name to get
     */
    static getTable(name){
        if(name==""){
            world.sendMessage("Table name not allowed! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                world.sendMessage("Table found! Returns table "+name); return this.table.get(name);
            }else {
                world.sendMessage("Table not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Sets a value in a given table
     * @param {string} name Table name (key)
     * @param {string} key Table's value (key) to set
     * @param {string|number|Array|any} value The value to set to
     * @returns {undefined|string|number|Array|any}
     */
    static setInTable(name, key, value){
        if(name == "" || key == "" || value == ""){
            world.sendMessage("Given \"\"! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                if(this.table.get(name).has(key)){
                    world.sendMessage("Table value set! Returns value"); this.table.get(name).set(key, value); return this.table.get(name).get(key);
                }else {
                    world.sendMessage("Table value not found! Returns undefined"); return undefined;
                };
            }else {
                world.sendMessage("Table not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Sets a value in a given table
     * @param {string} name Table name (key)
     * @param {string} key Table's value (key) to set
     * @param {string|number|Array|any} value The value to set to
     * @returns {undefined|string|number|Array|any}
     */
    static newKeyInTable(name, key, value){
        if(name == "" || key == ""){
            world.sendMessage("Given \"\"! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                if(this.table.get(name).has(key)){
                    world.sendMessage("Table value already set! Returns table");return this.table.get(name).get(key);
                }else {
                    this.table.get(name).set(key, value);
                    world.sendMessage("New Table value set! Returns table"); return this.table.get(name).get(key);
                };
            }else {
                world.sendMessage("Table not found! Returns undefined"); return this.table.get(name).set(key, value);
            };
        };
    };
    /**
     * Deletes a table
     * @param {string} name The table to delete
     * @returns {undefined|Map}
     */
    static deleteTable(name){
        if(name == ""){
            world.sendMessage("Given \"\" as table name! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                let ov = this.table.get(name); this.table.delete(name); world.sendMessage("Succesfully deleted Table! Returns "+name); return ov;
            }else {
                world.sendMessage("Table to delete not found! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Deletes a value (key) in a given table
     * @param {string} name The table the key is located in
     * @param {string} key The key to delete
     * @returns {undefined|void}
     */
    static deleteInTable(name, key){
        if(name == ""){
            world.sendMessage("Given \"\" as table name! Returns undefined"); return undefined;
        }else {
            if(this.table.has(name)){
                this.table.get(name).delete(key);
            }else {
                world.sendMessage("Given key does not exist inn table! Returns undefined"); return undefined;
            };
        };
    };
    /**
     * Loads the data from a saved Json table string
     * @param {string} tables A JSON saved Map in string
     */
    static loadSaveString(tables) {
        let r = JSON.parse(tables);
        for(let key = 0; key < r.length; key++){
            this.table.set(r[key][0], new Map(Object.entries(r[key][1])));
        };
        world.sendMessage("Loaded Database set")
        return this.table;
    };
    /**
     * Returns a JSON string of the table data
     * @returns {string} A string that can be loaded with Database.loadSaveString()
     */
    static getSaveString() {
        let vals = [];
        this.table.forEach((val)=>{
            let jsonF = Object.fromEntries(val);
            //world.sendMessage(jsonF); 	    // {k:v}
            vals.push(jsonF);
        });
        let keys = Array.from(this.table.keys());
        let r = [];
        for(let k = 0; k < keys.length; k++){
            let pair = [keys[k], vals[k]];
            //world.sendMessage(pair);
            r.push(pair);
        };
        return JSON.stringify(r);
    };
    /**
     * Gets a key's value in a table
     * @param {string} name The table to look in for
     * @param {string} key The key in the table to look for
     * @returns {undefined|any}
     */
    static getInTable(name, key){
        if(this.table.has(name)){
            if(this.table.get(name).has(key)){
                return this.table.get(name).get(key);
            }else {
                world.sendMessage("Key not found! Returns undefined"); return undefined;
            };
        }else {
            world.sendMessage("Table not found! Returns undefined, searched "+name); return undefined;
        };
    };
    /**
     * Saves the Database inside an object's dynamic property
     * @param {string} property The dynamic property's identifier
     * @param {World|Entity} object The object to save in
     */
    static saveDatabase(property, object){
        object.setDynamicProperty(property, this.getSaveString());
        if(object instanceof World){
            console.warn("Saved Database in World Dynamic Properties as "+property);
        }else {
            console.warn("Saved Database in Entity with Id "+ object.id+" as "+ property);
        };
    };
    /**
     * @type {Map<string, Map<string, string|number|Array>>}
     */
    static table = new Map();
};